/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.util.JavaUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AirItem;
import net.minecraft.item.BedItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;

public final class BlockUtils {
    @NotNull
    public static final List<BiPredicate<Block, BlockState>> FREE_TO_PLACE_BLOCKS = Arrays.asList((block, iBlockState) -> block.equals(Blocks.field_150350_a), (block, iBlockState) -> iBlockState.func_185904_a().func_76224_d(), (block, iBlockState) -> BlockUtils.isWater(block.func_176223_P()), (block, iBlockState) -> block instanceof LeavesBlock, (block, iBlockState) -> block instanceof DoublePlantBlock, (block, iBlockState) -> block.equals(Blocks.field_150349_c), (block, iBlockState) -> block instanceof DoorBlock && iBlockState != null && (Boolean)iBlockState.func_177229_b((Property)BooleanProperty.func_177716_a((String)"upper")) != false);

    private BlockUtils() {
    }

    public static Rotation getRotation(int rotation) {
        switch (rotation) {
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static int getRotationFromFacing(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case EAST: {
                return 1;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static BlockState getSubstitutionBlockAtWorld(@NotNull World world, @NotNull BlockPos location) {
        BlockState filler = world.func_226691_t_((BlockPos)location).field_242424_k.func_242502_e().func_204108_a();
        if (filler.func_177230_c() == Blocks.field_150354_m) {
            return Blocks.field_150322_A.func_176223_P();
        }
        if (filler.func_177230_c() instanceof FallingBlock) {
            return Blocks.field_150346_d.func_176223_P();
        }
        return filler;
    }

    public static boolean isWater(BlockState iBlockState) {
        return iBlockState.func_177230_c() == Blocks.field_150355_j;
    }

    private static Item getItem(@NotNull BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block.equals(Blocks.field_150353_l)) {
            return Items.field_151129_at;
        }
        if (block instanceof CropsBlock) {
            ItemStack stack = ((CropsBlock)block).func_185473_a(null, null, blockState);
            if (stack != null) {
                return stack.func_77973_b();
            }
            return Items.field_151014_N;
        }
        if (block instanceof FarmlandBlock || block instanceof GrassPathBlock) {
            return BlockUtils.getItemFromBlock(Blocks.field_150346_d);
        }
        if (block instanceof FireBlock) {
            return Items.field_151033_d;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.field_222087_nH;
        }
        if (block == Blocks.field_222404_kP) {
            return Items.field_222068_kQ;
        }
        return BlockUtils.getItemFromBlock(block);
    }

    private static Item getItemFromBlock(Block block) {
        return (Item)GameData.getBlockItemMap().get(block);
    }

    public static boolean areBlockStatesEqual(BlockState structureState, BlockState worldState, Predicate<BlockState> shallReplace, boolean fancy, BiPredicate<BlockState, BlockState> specialEqualRule) {
        if (structureState == null || worldState == null) {
            return true;
        }
        Block structureBlock = structureState.func_177230_c();
        Block worldBlock = worldState.func_177230_c();
        if (worldState.equals(structureState)) {
            return true;
        }
        if (fancy) {
            if (structureBlock == ModBlocks.blockSubstitution.get()) {
                return true;
            }
            if (structureBlock instanceof AirBlock && worldBlock instanceof AirBlock) {
                return true;
            }
            if (structureBlock == Blocks.field_150346_d && worldBlock.func_203417_a((ITag)Tags.Blocks.DIRT)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockSolidSubstitution.get() && !shallReplace.test(worldState)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockFluidSubstitution.get() && (worldState.func_204520_s().func_206889_d() || !worldState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && worldState.func_185904_a().func_76220_a()) || worldBlock == ModBlocks.blockFluidSubstitution.get() && (structureState.func_204520_s().func_206889_d() || !structureState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && structureState.func_185904_a().func_76220_a())) {
                return true;
            }
        }
        return specialEqualRule.test(structureState, worldState);
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        return BlockUtils.getBlockStateFromStack(stack, Blocks.field_150350_a.func_176223_P());
    }

    public static BlockState getBlockStateFromStack(ItemStack stack, BlockState def) {
        if (stack.func_77973_b() == Items.field_190931_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (stack.func_77973_b() instanceof BucketItem) {
            return ((BucketItem)stack.func_77973_b()).getFluid().func_207188_f().func_206883_i();
        }
        if (stack.func_77973_b() instanceof BlockItem) {
            return ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        }
        return def;
    }

    public static ItemStack getItemStackFromBlockState(@NotNull BlockState blockState) {
        if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
            return new ItemStack((IItemProvider)((FlowingFluidBlock)blockState.func_177230_c()).getFluid().func_204524_b(), 1);
        }
        Item item = BlockUtils.getItem(blockState);
        if (item != Items.field_190931_a && item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
    }

    public static void handleCorrectBlockPlacement(World world, FakePlayer fakePlayer, ItemStack itemStack, BlockState blockState, BlockPos here) {
        ItemStack stackToPlace = itemStack.func_77946_l();
        Item item = stackToPlace.func_77973_b();
        stackToPlace.func_190920_e(stackToPlace.func_77976_d());
        if (item instanceof AirItem) {
            world.func_217377_a(here, false);
        } else if (item instanceof BlockItem) {
            Block targetBlock = ((BlockItem)item).func_179223_d();
            BlockState newState = BlockUtils.copyFirstCommonBlockStateProperties(targetBlock.func_176223_P(), blockState);
            if (newState == null) {
                fakePlayer.func_184611_a(Hand.MAIN_HAND, stackToPlace);
                if (item.func_206844_a((ITag)ItemTags.field_219771_F) && blockState.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
                    fakePlayer.field_70177_z = ((Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176736_b() * 90;
                }
                if ((newState = targetBlock.func_196258_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)fakePlayer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), itemStack.func_77973_b() instanceof BedItem ? Direction.UP : Direction.NORTH, here, true))))) == null) {
                    return;
                }
            }
            world.func_217377_a(here, false);
            world.func_180501_a(here, newState, 3);
            targetBlock.func_180633_a(world, here, newState, (LivingEntity)fakePlayer, stackToPlace);
        } else if (item instanceof BucketItem) {
            Block sourceBlock = blockState.func_177230_c();
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.getFluid();
            if (sourceBlock instanceof ILiquidContainer) {
                ILiquidContainer liquidContainer = (ILiquidContainer)sourceBlock;
                if (liquidContainer.func_204510_a((IBlockReader)world, here, blockState, fluid)) {
                    liquidContainer.func_204509_a((IWorld)world, here, blockState, fluid.func_207188_f());
                    bucket.func_203792_a(world, stackToPlace, here);
                }
            } else {
                world.func_217377_a(here, false);
                world.func_180501_a(here, fluid.func_207188_f().func_206883_i(), 3);
                bucket.func_203792_a(world, stackToPlace, here);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Cannot handle placing of {0} instead of {1}?!", itemStack.toString(), blockState.toString()));
        }
    }

    public static void removeFluid(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((!(block instanceof IBucketPickupHandler) || ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, state) == Fluids.field_204541_a) && block instanceof FlowingFluidBlock) {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public static BlockState getFluidForDimension(World world) {
        ResourceLocation res = world.func_241828_r().func_230520_a_().func_177774_c((Object)world.func_230315_m_());
        if (res == null) {
            return Blocks.field_150355_j.func_176223_P();
        }
        RegistryKey rk = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)res);
        return rk == DimensionType.field_236000_d_ ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P();
    }

    public static List<ItemStack> getBlockDrops(@NotNull World world, @NotNull BlockPos coords, int fortune, ItemStack stack) {
        return world.func_180495_p(coords).func_215693_a(new LootContext.Builder((ServerWorld)world).func_186469_a((float)fortune).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)coords.func_177958_n(), (double)coords.func_177956_o(), (double)coords.func_177952_p())).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(coords)).func_216015_a(LootParameters.field_216289_i, (Object)stack));
    }

    public static BlockState copyBlockStateProperties(Block target, BlockState propertiesOrigin) {
        return target.getClass().equals(propertiesOrigin.func_177230_c().getClass()) ? BlockUtils.unsafeCopyBlockStateProperties(target.func_176223_P(), propertiesOrigin, propertiesOrigin.func_235904_r_()) : null;
    }

    public static BlockState copyFirstCommonBlockStateProperties(BlockState target, BlockState propertiesOrigin) {
        BlockState sameClass = BlockUtils.copyBlockStateProperties(target.func_177230_c(), propertiesOrigin);
        if (sameClass != null) {
            return sameClass;
        }
        Class<?> firstCommonClass = JavaUtils.getFirstCommonSuperClass(target.func_177230_c().getClass(), propertiesOrigin.func_177230_c().getClass());
        if (firstCommonClass == Block.class || !Block.class.isAssignableFrom(firstCommonClass)) {
            return null;
        }
        ArrayList properties = new ArrayList(target.func_235904_r_());
        properties.retainAll(propertiesOrigin.func_235904_r_());
        return BlockUtils.unsafeCopyBlockStateProperties(target, propertiesOrigin, properties);
    }

    private static BlockState unsafeCopyBlockStateProperties(BlockState target, BlockState propertiesOrigin, Collection<Property<?>> properties) {
        BlockState blockState = target;
        for (Property<?> property : properties) {
            blockState = (BlockState)blockState.func_206870_a(property, propertiesOrigin.func_177229_b(property));
        }
        return blockState;
    }
}

